#!/bin/bash

# Get the directory where this script is located
DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" &> /dev/null && pwd )"
cd "$DIR"

# Set up environment for Flutter app
export LD_LIBRARY_PATH="$DIR/lib:$LD_LIBRARY_PATH"

# Set display if not set (for SSH sessions)
if [ -z "$DISPLAY" ]; then
    export DISPLAY=:0
fi

# Run the application
exec ./aso_dev "$@"
